# Vinayaka Electronics - Solar Solutions Website

A professional PHP-based website for Vinayaka Electronics, a leading solar energy solutions provider in Vijayapura, Karnataka, India.

## Features

### Pages
- **Home Page**: Welcome message, products overview, testimonials, and statistics
- **About Us**: Company history, vision, mission, and why choose us
- **Company Profile**: Culture, values, leadership principles, and employee expectations
- **Solar Calculator**: Interactive calculator to estimate solar installation costs and savings
- **Contact Us**: Contact information, inquiry form, and location map

### Solar Calculator
The solar calculator provides comprehensive calculations including:
- Suggested solar capacity (kW)
- Total investment required (INR)
- Monthly energy savings (kWh and INR)
- Required roof space (sqft)
- CO₂ emission reduction per year
- Payback period
- Environmental impact equivalents

Calculator supports three property types:
- Residential
- Commercial
- Industrial

## Technology Stack
- PHP 7.4+
- HTML5
- CSS3
- JavaScript (Vanilla)
- Responsive Design

## Contact Information

**Vinayaka Electronics**
Gonal Building, Behind Ram Bhat Joshi House
Ram Mandir Road, Vijayapura-586101
Karnataka, India

**Email:**
- info@vinayakaelectronicsvjpr.com
- vinayakaelectronics1994@gmail.com

**Phone:**
- +91-8050091625
- +91-9342916025
- +91-7619249505

## Leadership
**Managing Director:** Smt. Navya Veeresh Gonal

## Mission
"Technology for Humanity" - Delivering exceptional electronic solutions, fostering innovation, customer satisfaction, and employee growth, while contributing to the community's prosperity.

## Products & Services
- Solar Water Heater
- Solar Photovoltaic Systems
- Solar Heat Pumps
- Water Purification Systems
- Roof Top Solar
- Ground Mounted Solar
- On-grid and Off-grid Solar Systems
- Solar Street Lights
- Solar Pump Sets
- Li-ion Batteries
- Home UPS Inverters
- CCTV Security Systems

## Setup Instructions

1. Ensure you have PHP 7.4 or higher installed
2. Place all files in your web server directory (e.g., `/var/www/html/` or `htdocs/`)
3. Configure your web server to serve PHP files
4. Access the website through your browser

## File Structure
```
project/
├── index.php                 # Home page
├── about.php                 # About us page
├── company-profile.php       # Company profile page
├── solar-calculator.php      # Solar calculator
├── contact.php               # Contact page
├── includes/
│   ├── header.php           # Header component
│   └── footer.php           # Footer component
├── css/
│   └── style.css            # Main stylesheet
└── public/
    └── vinayaka_electronics_logo_.jpg  # Company logo
```

## Color Scheme
- Primary Color: Orange (#ff9500) - Representing solar energy
- Secondary Color: Blue (#0066cc) - Trust and reliability
- Accent Color: Green (#28a745) - Sustainability and environment
- Professional gradient backgrounds for modern look

## Browser Support
- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers

## Responsive Design
The website is fully responsive and optimized for:
- Desktop (1200px+)
- Tablet (768px - 1024px)
- Mobile (< 768px)

---

**Vinayaka Electronics** - Empowering Vijayapura with Sustainable & Innovative Solar Technology
