<?php
$page = 'profile';
$title = 'Company Profile - Vinayaka Electronics';
include 'includes/header.php';
?>

<section class="page-header">
    <div class="container">
        <h1>Company Profile</h1>
        <p>Our Culture, Values, and Commitment to Excellence</p>
    </div>
</section>

<section class="company-overview">
    <div class="container">
        <div class="profile-intro">
            <h2>Vinayaka Electronics, Vijayapura</h2>
            <p class="lead">Welcome to Vinayaka Electronics, Vijayapura's leading electronics retailer. Since 2006, we've provided top-quality products and exceptional customer service. Our mission is to deliver innovative solutions, exceeding customer expectations.</p>
        </div>

        <div class="company-details">
            <div class="detail-card">
                <h3>Company Name</h3>
                <p>Vinayaka Electronics</p>
            </div>

            <div class="detail-card">
                <h3>Location</h3>
                <p>Vijayapura, Karnataka, India</p>
            </div>

            <div class="detail-card">
                <h3>Established</h3>
                <p>2006</p>
            </div>

            <div class="detail-card">
                <h3>Managing Director</h3>
                <p>Smt. Navya Veeresh Gonal</p>
            </div>
        </div>
    </div>
</section>

<section class="mission-statement">
    <div class="container">
        <div class="statement-card">
            <h2>Mission Statement</h2>
            <p class="mission-text">"At Vinayaka Electronics, we strive to deliver exceptional electronic solutions, fostering innovation, customer satisfaction, and employee growth, while contributing to the community's prosperity."</p>
        </div>
    </div>
</section>

<section class="core-values">
    <div class="container">
        <h2>Core Values</h2>
        <div class="values-grid">
            <div class="value-card">
                <div class="value-number">1</div>
                <h3>Customer Delight</h3>
                <p>Exceed customer expectations through quality products and services.</p>
            </div>

            <div class="value-card">
                <div class="value-number">2</div>
                <h3>Innovation</h3>
                <p>Encourage creativity, experimentation, and learning.</p>
            </div>

            <div class="value-card">
                <div class="value-number">3</div>
                <h3>Integrity</h3>
                <p>Conduct business with transparency, ethics, and accountability.</p>
            </div>

            <div class="value-card">
                <div class="value-number">4</div>
                <h3>Teamwork</h3>
                <p>Collaborate, support, and respect each other.</p>
            </div>

            <div class="value-card">
                <div class="value-number">5</div>
                <h3>Continuous Improvement</h3>
                <p>Strive for excellence, efficiency, and growth.</p>
            </div>

            <div class="value-card">
                <div class="value-number">6</div>
                <h3>Community Focus</h3>
                <p>Contribute to the well-being of Vijayapura and its people.</p>
            </div>
        </div>
    </div>
</section>

<section class="culture-statement">
    <div class="container">
        <h2>Our Culture</h2>
        <div class="culture-content">
            <p class="culture-intro">At Vinayaka Electronics, we cultivate a dynamic, inclusive, and supportive work environment, where:</p>

            <div class="culture-points">
                <div class="culture-point">
                    <span class="point-icon">✓</span>
                    <p>Employees are empowered to take ownership and make decisions</p>
                </div>

                <div class="culture-point">
                    <span class="point-icon">✓</span>
                    <p>Open communication and feedback are encouraged</p>
                </div>

                <div class="culture-point">
                    <span class="point-icon">✓</span>
                    <p>Diversity and individuality are celebrated</p>
                </div>

                <div class="culture-point">
                    <span class="point-icon">✓</span>
                    <p>Learning and development opportunities are provided</p>
                </div>

                <div class="culture-point">
                    <span class="point-icon">✓</span>
                    <p>Work-life balance is respected</p>
                </div>

                <div class="culture-point">
                    <span class="point-icon">✓</span>
                    <p>Community involvement and social responsibility are valued</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="workplace-culture">
    <div class="container">
        <h2>Workplace Culture</h2>
        <div class="workplace-grid">
            <div class="workplace-card">
                <h3>Collaborative Environment</h3>
                <p>Open office spaces designed to foster teamwork and creativity</p>
            </div>

            <div class="workplace-card">
                <h3>Team Building</h3>
                <p>Regular activities and celebrations to strengthen bonds</p>
            </div>

            <div class="workplace-card">
                <h3>Recognition Programs</h3>
                <p>Employee recognition and rewards for outstanding performance</p>
            </div>

            <div class="workplace-card">
                <h3>Flexible Working</h3>
                <p>Flexible hours and work-from-home options when needed</p>
            </div>

            <div class="workplace-card">
                <h3>Professional Development</h3>
                <p>Continuous learning and skill enhancement opportunities</p>
            </div>

            <div class="workplace-card">
                <h3>Health & Wellness</h3>
                <p>Programs to support employee well-being</p>
            </div>
        </div>
    </div>
</section>

<section class="leadership-principles">
    <div class="container">
        <h2>Leadership Principles</h2>
        <div class="principles-list">
            <div class="principle-item">
                <span class="principle-number">1</span>
                <h3>Lead by Example</h3>
                <p>Demonstrate the values and behaviors we expect from our team</p>
            </div>

            <div class="principle-item">
                <span class="principle-number">2</span>
                <h3>Foster Trust & Transparency</h3>
                <p>Build an environment of openness and honesty</p>
            </div>

            <div class="principle-item">
                <span class="principle-number">3</span>
                <h3>Encourage Innovation</h3>
                <p>Support calculated risk-taking and creative problem-solving</p>
            </div>

            <div class="principle-item">
                <span class="principle-number">4</span>
                <h3>Develop & Empower</h3>
                <p>Invest in employee growth and decision-making capabilities</p>
            </div>

            <div class="principle-item">
                <span class="principle-number">5</span>
                <h3>Data-Driven Decisions</h3>
                <p>Make informed choices based on facts and analysis</p>
            </div>
        </div>
    </div>
</section>

<section class="employee-expectations">
    <div class="container">
        <h2>Employee Expectations</h2>
        <div class="expectations-grid">
            <div class="expectation-card">
                <h3>Ownership & Accountability</h3>
                <p>Take responsibility for your work and its outcomes</p>
            </div>

            <div class="expectation-card">
                <h3>Strive for Excellence</h3>
                <p>Pursue continuous improvement in all endeavors</p>
            </div>

            <div class="expectation-card">
                <h3>Effective Communication</h3>
                <p>Communicate clearly and respectfully with all stakeholders</p>
            </div>

            <div class="expectation-card">
                <h3>Support & Collaborate</h3>
                <p>Work together to achieve common goals</p>
            </div>

            <div class="expectation-card">
                <h3>Embody Our Values</h3>
                <p>Reflect company values and culture in daily actions</p>
            </div>
        </div>
    </div>
</section>

<section class="community-involvement">
    <div class="container">
        <h2>Community Involvement</h2>
        <div class="community-grid">
            <div class="community-card">
                <div class="community-icon">🤝</div>
                <h3>Social Initiatives</h3>
                <p>Partner with local organizations for community development</p>
            </div>

            <div class="community-card">
                <div class="community-icon">🎓</div>
                <h3>Education & Skills</h3>
                <p>Support education and skill development programs for youth</p>
            </div>

            <div class="community-card">
                <div class="community-icon">🌱</div>
                <h3>Environmental Conservation</h3>
                <p>Participate in efforts to protect and preserve the environment</p>
            </div>

            <div class="community-card">
                <div class="community-icon">🎪</div>
                <h3>Community Events</h3>
                <p>Host workshops and events for community benefit</p>
            </div>
        </div>
    </div>
</section>

<section class="recognition-rewards">
    <div class="container">
        <h2>Recognition & Rewards</h2>
        <div class="rewards-list">
            <div class="reward-item">
                <span class="reward-icon">🏆</span>
                <div class="reward-content">
                    <h3>Employee Awards</h3>
                    <p>Employee of the Month, Quarter, and Year recognition</p>
                </div>
            </div>

            <div class="reward-item">
                <span class="reward-icon">💰</span>
                <div class="reward-content">
                    <h3>Performance Incentives</h3>
                    <p>Bonuses and incentives based on performance</p>
                </div>
            </div>

            <div class="reward-item">
                <span class="reward-icon">👏</span>
                <div class="reward-content">
                    <h3>Public Recognition</h3>
                    <p>Celebration of achievements company-wide</p>
                </div>
            </div>

            <div class="reward-item">
                <span class="reward-icon">🌟</span>
                <div class="reward-content">
                    <h3>Community Volunteer Leave</h3>
                    <p>Additional leave days for community service work</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="product-range">
    <div class="container">
        <h2>Our Product Range</h2>
        <div class="products-overview">
            <div class="product-category">
                <h3>Solar Solutions</h3>
                <ul>
                    <li>On-grid and off-grid solar systems</li>
                    <li>Roof top solar installations</li>
                    <li>Solar street lights</li>
                    <li>Solar pump sets</li>
                    <li>Solar for petrol bunks</li>
                    <li>Solar water heaters</li>
                </ul>
            </div>

            <div class="product-category">
                <h3>Energy Storage</h3>
                <ul>
                    <li>Li-ion batteries</li>
                    <li>Battery chargers</li>
                    <li>Tubular batteries for solar</li>
                    <li>Inverter batteries</li>
                    <li>Home UPS systems</li>
                </ul>
            </div>

            <div class="product-category">
                <h3>Home Appliances</h3>
                <ul>
                    <li>Televisions</li>
                    <li>Refrigerators</li>
                    <li>Air Conditioners</li>
                    <li>Audio-visual equipment</li>
                    <li>Speakers and projectors</li>
                </ul>
            </div>

            <div class="product-category">
                <h3>Security Solutions</h3>
                <ul>
                    <li>CCTV cameras</li>
                    <li>Alarm systems</li>
                    <li>Security equipment</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="cta-section">
    <div class="container">
        <h2>Join Our Journey</h2>
        <p>Be part of our mission to bring technology for humanity</p>
        <a href="contact.php" class="btn btn-primary">Contact Us Today</a>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
