<?php
$page = 'contact';
$title = 'Contact Us - Vinayaka Electronics';
include 'includes/header.php';

$messageSent = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = htmlspecialchars($_POST['name'] ?? '');
    $email = htmlspecialchars($_POST['email'] ?? '');
    $phone = htmlspecialchars($_POST['phone'] ?? '');
    $subject = htmlspecialchars($_POST['subject'] ?? '');
    $message = htmlspecialchars($_POST['message'] ?? '');

    if ($name && $email && $message) {
        $to = 'info@vinayakaelectronicsvjpr.com';
        $emailSubject = 'Contact Form: ' . $subject;
        $emailBody = "Name: $name\nEmail: $email\nPhone: $phone\n\nMessage:\n$message";
        $headers = "From: $email";

        if (mail($to, $emailSubject, $emailBody, $headers)) {
            $messageSent = true;
        } else {
            $error = 'Sorry, there was an error sending your message. Please try again or contact us directly.';
        }
    } else {
        $error = 'Please fill in all required fields.';
    }
}
?>

<section class="page-header">
    <div class="container">
        <h1>Contact Us</h1>
        <p>Get in Touch with Vinayaka Electronics</p>
    </div>
</section>

<section class="contact-section">
    <div class="container">
        <?php if ($messageSent): ?>
            <div class="success-message">
                <h3>Thank You!</h3>
                <p>Your message has been sent successfully. We will get back to you soon.</p>
            </div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="error-message">
                <p><?php echo $error; ?></p>
            </div>
        <?php endif; ?>

        <div class="contact-grid">
            <div class="contact-info">
                <h2>Visit Our Office</h2>
                <div class="info-card">
                    <h3>📍 Address</h3>
                    <p>
                        Gonal Building,<br>
                        Behind Ram Bhat Joshi House,<br>
                        Ram Mandir Road,<br>
                        Vijayapura - 586101,<br>
                        Karnataka, India
                    </p>
                </div>

                <div class="info-card">
                    <h3>📧 Email</h3>
                    <p>
                        <a href="mailto:info@vinayakaelectronicsvjpr.com">info@vinayakaelectronicsvjpr.com</a><br>
                        <a href="mailto:vinayakaelectronics1994@gmail.com">vinayakaelectronics1994@gmail.com</a>
                    </p>
                </div>

                <div class="info-card">
                    <h3>📱 Phone</h3>
                    <p>
                        <a href="tel:+918050091625">+91-8050091625</a><br>
                        <a href="tel:+919342916025">+91-9342916025</a><br>
                        <a href="tel:+917619249505">+91-7619249505</a>
                    </p>
                </div>

                <div class="info-card">
                    <h3>⏰ Business Hours</h3>
                    <p>
                        Monday - Saturday: 9:00 AM - 7:00 PM<br>
                        Sunday: Closed
                    </p>
                </div>

                <div class="social-info">
                    <h3>Follow Us</h3>
                    <p>Facebook: @vinayakaelectronicsvijayapur</p>
                    <p>Instagram: @vinayakaelectronics</p>
                    <p>Twitter: @vinayakaelec</p>
                </div>
            </div>

            <div class="contact-form-wrapper">
                <h2>Send Us a Message</h2>
                <form method="POST" class="contact-form">
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input type="text" id="name" name="name" required>
                    </div>

                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input type="email" id="email" name="email" required>
                    </div>

                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input type="tel" id="phone" name="phone">
                    </div>

                    <div class="form-group">
                        <label for="subject">Subject</label>
                        <select id="subject" name="subject">
                            <option value="General Inquiry">General Inquiry</option>
                            <option value="Solar Installation">Solar Installation</option>
                            <option value="Product Information">Product Information</option>
                            <option value="Service Request">Service Request</option>
                            <option value="Training Programs">Training Programs</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="message">Your Message *</label>
                        <textarea id="message" name="message" rows="6" required></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Send Message</button>
                </form>
            </div>
        </div>
    </div>
</section>

<section class="map-section">
    <div class="container">
        <h2>Find Us on Map</h2>
        <div class="map-wrapper">
            <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3843.8!2d75.71!3d16.83!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMTbCsDQ5JzQ4LjAiTiA3NcKwNDInMzYuMCJF!5e0!3m2!1sen!2sin!4v1234567890"
                width="100%"
                height="450"
                style="border:0;"
                allowfullscreen=""
                loading="lazy">
            </iframe>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
