<?php
$page = 'home';
$title = 'Vinayaka Electronics - Solar Solutions in Vijayapura';
include 'includes/header.php';
?>

<section class="hero">
    <div class="hero-overlay"></div>
    <div class="container hero-content">
        <img src="public/vinayaka_electronics_logo_.jpg" alt="Vinayaka Electronics Logo" class="hero-logo">
        <h1>Welcome to Vinayaka Electronics</h1>
        <p class="hero-subtitle">Your Trusted Partner in Solar Energy Solutions</p>
        <p class="hero-description">Empowering Vijayapura with Sustainable & Innovative Solar Technology</p>
        <div class="hero-buttons">
            <a href="solar-calculator.php" class="btn btn-primary">Solar Calculator</a>
            <a href="contact.php" class="btn btn-secondary">Contact Us</a>
        </div>
    </div>
</section>

<section class="welcome-message">
    <div class="container">
        <h2>Dear Valued Customers</h2>
        <p>Thank you for choosing Vinayaka Electronics for your solar products, training programs, and servicing needs.</p>

        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">🌞</div>
                <h3>Sustainable Energy Solutions</h3>
                <p>Your support helps us provide innovative solar products for a greener future.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">👥</div>
                <h3>Empowering Youth</h3>
                <p>Our job-oriented courses for unemployed youths are transforming lives, thanks to your trust.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">⚙️</div>
                <h3>Comprehensive Service</h3>
                <p>Our scientific service center ensures top-notch care for all your electronic and electrical products.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">💡</div>
                <h3>Technology for Humanity</h3>
                <p>We are committed to making a positive impact through technology.</p>
            </div>
        </div>

        <div class="message-footer">
            <p>We look forward to continuing to serve you with excellence.</p>
            <p class="signature"><strong>Warm regards,</strong><br>
            <strong>Smt. Navya Veeresh Gonal</strong><br>
            Managing Director<br>
            Vinayaka Electronics, Vijayapur-586101, Karnataka State, India</p>
        </div>
    </div>
</section>

<section class="products-services">
    <div class="container">
        <h2>Our Products & Services</h2>
        <div class="products-grid">
            <div class="product-card">
                <div class="product-icon">☀️</div>
                <h3>Solar Water Heater</h3>
                <p>Efficient water heating solutions using solar energy</p>
            </div>

            <div class="product-card">
                <div class="product-icon">⚡</div>
                <h3>Solar Photovoltaic</h3>
                <p>Convert sunlight directly into electricity</p>
            </div>

            <div class="product-card">
                <div class="product-icon">🔆</div>
                <h3>Solar Heat Pumps</h3>
                <p>Energy-efficient heating and cooling systems</p>
            </div>

            <div class="product-card">
                <div class="product-icon">💧</div>
                <h3>Water Purification Systems</h3>
                <p>Clean, safe drinking water solutions</p>
            </div>

            <div class="product-card">
                <div class="product-icon">🏠</div>
                <h3>Roof Top Solar</h3>
                <p>Maximize your roof space for solar energy</p>
            </div>

            <div class="product-card">
                <div class="product-icon">🌍</div>
                <h3>Ground Mounted Solar</h3>
                <p>Large-scale solar installations</p>
            </div>
        </div>
    </div>
</section>

<section class="brands-section">
    <div class="container">
        <h2>All Brands Available</h2>
        <p class="section-subtitle">We partner with leading solar manufacturers to bring you the best quality products</p>
        <div class="brands-banner">
            <p>✓ Premium Quality Components</p>
            <p>✓ Certified Products</p>
            <p>✓ Warranty Support</p>
            <p>✓ Latest Technology</p>
        </div>
    </div>
</section>

<section class="projects-section">
    <div class="container">
        <h2>Our Projects in Karnataka</h2>
        <p class="section-subtitle">Delivering excellence across Karnataka with numerous successful solar installations</p>
        <div class="projects-stats">
            <div class="stat-card">
                <h3>500+</h3>
                <p>Projects Completed</p>
            </div>
            <div class="stat-card">
                <h3>10MW+</h3>
                <p>Solar Capacity Installed</p>
            </div>
            <div class="stat-card">
                <h3>1000+</h3>
                <p>Happy Customers</p>
            </div>
            <div class="stat-card">
                <h3>15+</h3>
                <p>Years Experience</p>
            </div>
        </div>
    </div>
</section>

<section class="testimonials-section">
    <div class="container">
        <h2>What Our Customers Say</h2>
        <div class="testimonials-grid">
            <div class="testimonial-card">
                <p class="testimonial-text">"Excellent service and quality products. Our solar installation has reduced our electricity bills significantly."</p>
                <p class="testimonial-author">- Residential Customer, Vijayapura</p>
            </div>

            <div class="testimonial-card">
                <p class="testimonial-text">"Professional team and timely installation. Highly recommend Vinayaka Electronics for solar solutions."</p>
                <p class="testimonial-author">- Commercial Client, Karnataka</p>
            </div>

            <div class="testimonial-card">
                <p class="testimonial-text">"Great after-sales support and maintenance service. They truly care about customer satisfaction."</p>
                <p class="testimonial-author">- Industrial Customer, Vijayapura</p>
            </div>
        </div>
    </div>
</section>

<section class="cta-section">
    <div class="container">
        <h2>Ready to Go Solar?</h2>
        <p>Calculate your solar investment and savings today!</p>
        <a href="solar-calculator.php" class="btn btn-large">Use Solar Calculator</a>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
