<?php
$page = 'calculator';
$title = 'Solar Calculator - Vinayaka Electronics';
include 'includes/header.php';
?>

<section class="page-header">
    <div class="container">
        <h1>Solar Calculator</h1>
        <p>Calculate Your Solar Investment and Savings</p>
    </div>
</section>

<section class="calculator-section">
    <div class="container">
        <div class="calculator-intro">
            <p>Use our solar calculator to estimate the capacity, investment, savings, and environmental impact of installing solar panels on your property. Simply enter your details below and get instant results.</p>
        </div>

        <div class="calculator-wrapper">
            <div class="calculator-form">
                <h2>Enter Your Details</h2>

                <div class="form-group">
                    <label for="propertyType">Property Type</label>
                    <select id="propertyType" onchange="calculateSolar()">
                        <option value="residential">Residential</option>
                        <option value="commercial">Commercial</option>
                        <option value="industrial">Industrial</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="availableArea">Available Roof Area (sqft)</label>
                    <input type="number" id="availableArea" placeholder="Enter area in square feet" min="0" oninput="calculateSolar()">
                    <small>Enter the available roof space for solar panel installation</small>
                </div>

                <div class="form-group">
                    <label for="monthlyBill">Average Monthly Electricity Bill (INR)</label>
                    <input type="number" id="monthlyBill" placeholder="Enter monthly bill amount" min="0" oninput="calculateSolar()">
                    <small>Enter your average monthly electricity bill</small>
                </div>

                <button onclick="calculateSolar()" class="btn btn-primary">Calculate</button>
            </div>

            <div class="calculator-results" id="resultsSection" style="display: none;">
                <h2>Your Solar Solution</h2>

                <div class="results-grid">
                    <div class="result-card highlight">
                        <div class="result-icon">⚡</div>
                        <h3>Suggested Capacity</h3>
                        <p class="result-value" id="suggestedCapacity">-</p>
                        <p class="result-unit">kW</p>
                    </div>

                    <div class="result-card">
                        <div class="result-icon">💰</div>
                        <h3>Total Investment</h3>
                        <p class="result-value" id="totalInvestment">-</p>
                        <p class="result-unit">INR</p>
                    </div>

                    <div class="result-card">
                        <div class="result-icon">📊</div>
                        <h3>Monthly Saving (kWh)</h3>
                        <p class="result-value" id="monthlySavingKwh">-</p>
                        <p class="result-unit">kWh</p>
                    </div>

                    <div class="result-card highlight">
                        <div class="result-icon">💵</div>
                        <h3>Monthly Saving (INR)</h3>
                        <p class="result-value" id="monthlySavingInr">-</p>
                        <p class="result-unit">INR</p>
                    </div>

                    <div class="result-card">
                        <div class="result-icon">📐</div>
                        <h3>Required Space</h3>
                        <p class="result-value" id="requiredSpace">-</p>
                        <p class="result-unit">sqft</p>
                    </div>

                    <div class="result-card highlight">
                        <div class="result-icon">🌱</div>
                        <h3>CO₂ Reduction/Year</h3>
                        <p class="result-value" id="co2Reduction">-</p>
                        <p class="result-unit">kg CO₂</p>
                    </div>

                    <div class="result-card">
                        <div class="result-icon">💚</div>
                        <h3>Total Yearly Savings</h3>
                        <p class="result-value" id="yearlySaving">-</p>
                        <p class="result-unit">INR</p>
                    </div>

                    <div class="result-card">
                        <div class="result-icon">⏱️</div>
                        <h3>Payback Period</h3>
                        <p class="result-value" id="paybackPeriod">-</p>
                        <p class="result-unit">years</p>
                    </div>
                </div>

                <div class="result-summary">
                    <h3>Environmental Impact</h3>
                    <p>Your solar installation would be equivalent to:</p>
                    <div class="impact-stats">
                        <div class="impact-item">
                            <span id="treesEquivalent">-</span> trees planted
                        </div>
                        <div class="impact-item">
                            <span id="carsOffRoad">-</span> cars off the road for a year
                        </div>
                    </div>
                </div>

                <div class="cta-results">
                    <p>Interested in installing solar panels?</p>
                    <a href="contact.php" class="btn btn-primary">Contact Us for Free Consultation</a>
                </div>
            </div>
        </div>

        <div class="calculator-info">
            <h2>How We Calculate</h2>
            <div class="info-grid">
                <div class="info-card">
                    <h3>System Capacity</h3>
                    <p>Based on your monthly bill and property type, we calculate the optimal solar system size. Residential systems are typically sized at 80% of consumption, while commercial and industrial systems can be sized at 100%.</p>
                </div>

                <div class="info-card">
                    <h3>Investment Cost</h3>
                    <p>Installation costs vary by property type. Residential systems cost approximately ₹50,000-60,000 per kW, commercial systems ₹45,000-55,000 per kW, and industrial systems ₹40,000-50,000 per kW.</p>
                </div>

                <div class="info-card">
                    <h3>Space Requirements</h3>
                    <p>Solar panels typically require 100-120 square feet per kW of capacity, depending on panel efficiency and mounting configuration.</p>
                </div>

                <div class="info-card">
                    <h3>Environmental Impact</h3>
                    <p>Each kW of solar capacity reduces approximately 1,500 kg of CO₂ emissions annually, equivalent to planting 75 trees per year.</p>
                </div>
            </div>
        </div>

        <div class="calculator-benefits">
            <h2>Why Choose Solar?</h2>
            <div class="benefits-grid">
                <div class="benefit-item">
                    <div class="benefit-icon">💰</div>
                    <h3>Reduce Electricity Bills</h3>
                    <p>Save up to 90% on your monthly electricity costs</p>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">🌍</div>
                    <h3>Environmental Benefits</h3>
                    <p>Reduce your carbon footprint significantly</p>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">📈</div>
                    <h3>Increase Property Value</h3>
                    <p>Solar installations increase property value by 3-4%</p>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">🔋</div>
                    <h3>Energy Independence</h3>
                    <p>Generate your own clean energy</p>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">🏆</div>
                    <h3>Government Subsidies</h3>
                    <p>Avail government subsidies and incentives</p>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">⚡</div>
                    <h3>Low Maintenance</h3>
                    <p>Minimal maintenance with 25+ years lifespan</p>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function calculateSolar() {
    const propertyType = document.getElementById('propertyType').value;
    const availableArea = parseFloat(document.getElementById('availableArea').value) || 0;
    const monthlyBill = parseFloat(document.getElementById('monthlyBill').value) || 0;

    if (availableArea === 0 || monthlyBill === 0) {
        document.getElementById('resultsSection').style.display = 'none';
        return;
    }

    const avgElectricityRate = 7;

    const monthlyConsumptionKwh = monthlyBill / avgElectricityRate;

    const avgSunHoursPerDay = 5.5;
    const systemEfficiency = 0.8;
    const daysInMonth = 30;

    let capacityMultiplier;
    let costPerKw;
    let spacePerKw;

    if (propertyType === 'residential') {
        capacityMultiplier = 0.8;
        costPerKw = 55000;
        spacePerKw = 110;
    } else if (propertyType === 'commercial') {
        capacityMultiplier = 1.0;
        costPerKw = 50000;
        spacePerKw = 105;
    } else {
        capacityMultiplier = 1.0;
        costPerKw = 45000;
        spacePerKw = 100;
    }

    let suggestedCapacityKw = (monthlyConsumptionKwh * capacityMultiplier) / (avgSunHoursPerDay * daysInMonth * systemEfficiency);

    const requiredSpaceSqft = suggestedCapacityKw * spacePerKw;

    if (requiredSpaceSqft > availableArea) {
        suggestedCapacityKw = availableArea / spacePerKw;
    }

    suggestedCapacityKw = Math.round(suggestedCapacityKw * 10) / 10;

    const totalInvestment = Math.round(suggestedCapacityKw * costPerKw);

    const monthlyGenerationKwh = Math.round(suggestedCapacityKw * avgSunHoursPerDay * daysInMonth * systemEfficiency);

    const monthlySavingInr = Math.round(monthlyGenerationKwh * avgElectricityRate);

    const actualRequiredSpace = Math.round(suggestedCapacityKw * spacePerKw);

    const co2ReductionPerYear = Math.round(suggestedCapacityKw * 1500);

    const yearlySaving = monthlySavingInr * 12;

    const paybackPeriod = (totalInvestment / yearlySaving).toFixed(1);

    const treesEquivalent = Math.round(suggestedCapacityKw * 75);
    const carsOffRoad = Math.round(suggestedCapacityKw * 0.35);

    document.getElementById('suggestedCapacity').textContent = suggestedCapacityKw.toFixed(1);
    document.getElementById('totalInvestment').textContent = '₹ ' + totalInvestment.toLocaleString('en-IN');
    document.getElementById('monthlySavingKwh').textContent = monthlyGenerationKwh.toLocaleString('en-IN');
    document.getElementById('monthlySavingInr').textContent = '₹ ' + monthlySavingInr.toLocaleString('en-IN');
    document.getElementById('requiredSpace').textContent = actualRequiredSpace.toLocaleString('en-IN');
    document.getElementById('co2Reduction').textContent = co2ReductionPerYear.toLocaleString('en-IN');
    document.getElementById('yearlySaving').textContent = '₹ ' + yearlySaving.toLocaleString('en-IN');
    document.getElementById('paybackPeriod').textContent = paybackPeriod;
    document.getElementById('treesEquivalent').textContent = treesEquivalent.toLocaleString('en-IN');
    document.getElementById('carsOffRoad').textContent = carsOffRoad;

    document.getElementById('resultsSection').style.display = 'block';
}
</script>

<?php include 'includes/footer.php'; ?>
